
# A simple demo application that parses an SGML document and prints an
# ESIS-like version of it.

import pysp, sys

# --- ESISWriter

class ESISWriter:

    def __init__(self, out):
        self._out = out

    def start_element(self, name, attrs):
        for (aname, value) in attrs.items():
            self._out.write("A%s %s\n" % (aname, repr(value)))
        self._out.write("(%s\n" % name)

    def end_element(self, name):
        self._out.write(")%s\n" % name)

    def data(self, data):
        self._out.write("-%s\n" % repr(data))

    def pi(self, data):
        self._out.write("?%s\n" % repr(data))

    def error(self, msg):
        self._out.write("ERROR: %s\n" % msg[ : -1])
        

# --- Main program

if len(sys.argv) == 3:
    # if a catalog file is specified on the command line then read it
    pysp.add_catalog(sys.argv[2])

parser = pysp.make_parser(sys.argv[1])
parser.run(ESISWriter(sys.stdout))
